/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.login;

import com.ibm.hwmca.fw.connmgr.ConnectionConstants;
import com.ibm.hwmca.fw.connmgr.ConnectionFactory;
import com.ibm.hwmca.fw.servlet.login.HmcPrincipal;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthFilter
implements Filter {
    private static final String TRACE_MASKT = "XAUTHFIT";
    private static final String TRACE_MASKF = "XAUTHFIF";

    public void init(FilterConfig config) throws ServletException {
        Trace.trace(TRACE_MASKT, "<> AuthFilter.init");
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws ServletException, IOException {
        Trace.trace(TRACE_MASKT, "-> AuthFilter.doFilter");
        if (req instanceof HttpServletRequest) {
            HttpServletRequest httpReq = (HttpServletRequest)req;
            HttpServletResponse httpResp = (HttpServletResponse)resp;
            HmcPrincipal principal = (HmcPrincipal)httpReq.getSession().getAttribute("PRINCIPAL");
            if (principal != null) {
                Trace.trace(TRACE_MASKF, "AuthFilter: found principal [" + principal + "].. allowing access");
                chain.doFilter(req, resp);
            } else {
                Trace.trace(TRACE_MASKF, "AuthFilter: no principal found");
                String uri = httpReq.getRequestURI();
                if (uri.equals("/hmc/login") || uri.equals("/hmc/login.jsp")) {
                    Trace.trace(TRACE_MASKF, "AuthFilter: allowing access to login servlet");
                    chain.doFilter(req, resp);
                } else if (uri.equals("/hmc/preLogon")) {
                    String remoteAddr = httpReq.getRemoteAddr();
                    Trace.trace(TRACE_MASKF, "AuthFilter: testing access to preLogon servlet from " + remoteAddr);
                    if ("127.0.0.1".equals(remoteAddr)) {
                        Trace.trace(TRACE_MASKF, "AuthFilter: allowing access to preLogon servlet.. creating Principal");
                        ConnectionFactory connFactory = new ConnectionFactory(CommonSystem.getCommonSystem().getManagerHost(), 9940);
                        try {
                            connFactory.setUserAndPassword("logonuser", ConnectionConstants.LOGON_PASSWORD);
                        }
                        catch (Exception e) {
                            Trace.trace(TRACE_MASKF, e);
                        }
                        principal = new HmcPrincipal("logonuser", connFactory);
                        httpReq.getSession().setAttribute("PRINCIPAL", (Object)principal);
                        chain.doFilter(req, resp);
                    } else {
                        Trace.trace(TRACE_MASKF, "AuthFilter: attempt to run preLogon servlet from non-local host.. rejecting");
                        httpResp.sendRedirect(httpResp.encodeRedirectURL("/hmc/login.jsp"));
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "AuthFilter: disallowing access to URI " + uri);
                    httpResp.sendRedirect(httpResp.encodeRedirectURL("/hmc/login.jsp"));
                }
            }
        } else {
            chain.doFilter(req, resp);
        }
        Trace.trace(TRACE_MASKF, "<- AuthFilter.doFilter");
    }

    public void destroy() {
        Trace.trace(TRACE_MASKT, "<> AuthFilter.destroy()");
    }
}

